# Icinga Knowledge Base - IWKB000017

## Short Message

Icinga throws exception during plugin execution after uninstalling SCOM or other vendor software using PowerShell modules

## Example Exception

Icinga throws the exception

`The Icinga PowerShell Framework is either not installed on the system or not configured properly. Please check https://icinga.com/docs/windows for further details`

once a plugin is executed from the Icinga Agent after SCOM is uninstalled as example.

## Reason

In some cases uninstalling certain software components which also ship PowerShell modules, like the Microsoft SCOM, Icinga for Windows will stop working. The Icinga Agent will assume that the PowerShell Framework is no longer installed as it cannot find the module afterwards.

## Solution

The simple solution is to restart the Icinga Agent service which will resolve this issue and reload the environment variables. Afterwards the checks will work as before.

```powershell
Restart-Icinga
````
