# Icinga Knowledge Base - IWKB000004

## Short Message

Use-Icinga : The 'Use-Icinga' command was found in the module 'icinga-powershell-framework', but the module could not be loaded. For more information, run 'Import-Module icinga-powershell-framework'

## Example Exception

Use-Icinga : The 'Use-Icinga' command was found in the module 'icinga-powershell-framework', but the module could not be loaded. For more information, run 'Import-Module icinga-powershell-framework'.

At line:1 char:1 + Use-Icinga; exit Invoke-IcingaCheckMemory -CriticalPercent 99 -Warnin ... + ~~~~~~~~~~

\+ CategoryInfo : ObjectNotFound:
(Use-Icinga:String) [], CommandNotFoundException + FullyQualifiedErrorId : CouldNotAutoloadMatchingModule Invoke-IcingaCheckMemory : The term 'Invoke-IcingaCheckMemory' is not recognized as the name of a cmdlet, function, script file, or operable program. Check the spelling of the name, or if a path was included, verify that the path is correct and try again.

At line:1 char:18 + Use-Icinga; exit Invoke-IcingaCheckMemory -CriticalPercent 99 -Warnin ... + ~~~~~~~~~~~~~~~~~~~~~~~~ + CategoryInfo : ObjectNotFound: (Invoke-IcingaCheckMemory:String ) [], CommandNotFoundException + FullyQualifiedErrorId : CommandNotFoundException

## Reason

This error can have multiple reasons and different solutions. Most of the time this issue is caused either by `Execution Policies` and/or PowerShell files being blocked on the system. It does how ever mean the installation of the specific PowerShell module itself is fine and just some smaller tweaks are required.

## Solutions

### Import the Module

Sometimes this issue can already be resolved by simply importing the module once with a user. In that case, all files are properly read and the module is available on the system. The corresponding module is always named within the exception messages. In this example, it is the `icinga-powershell-framework`. To import this module we simply run

```powershell
Import-Module 'icinga-powershell-framework';
```

In case no error occurs, we can continue this step for all affected modules and check if Icinga can now execute the commands. If not, please read on.

### Unblock PowerShell Files

Sometimes even with proper defined `Execution Policies` the execution of plugins or commands could fail. To resolve this, you can simply unblock the files of a specific folder. In this example we will assume that that modules are installed into `C:\Program Files\WindowsPowerShell\Modules` and our module name is `icinga-powershell-framework`.

```powershell
Get-ChildItem `
    -Path 'C:\Program Files\WindowsPowershell\Modules\icinga-powershell-framework' `
    -Recurse | Unblock-File
```

Repeat this for all affected modules and try again to execute plugins by Icinga. If the issue is not resolved, please read on

### Configure Execution Policies

Within the [Microsoft Docs](https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.security/set-executionpolicy) there is a very detailed article on how `Execution Policies` work. In general these policies define on how PowerShell scripts and modules are being handled and if they can be executed by users.

Before doing any modifications on `Execution Policies`, please check your internal security guidelines which rules should apply.

To check on how the current `Execution Policies` are configured on the host, you can run this:

```powershell
Get-ExecutionPolicy -List
```

There are different scopes available to set policies for:

* **MachinePolicy**: Set by a Group Policy for all users of the computer
* **UserPolicy**: Set by a Group Policy for the current user of the computer
* **Process**: Affects only the current PowerShell session
* **CurrentUser**: Affects only the current user
* **LocalMachine**: Default scope that affects all users of the computer

For each scope, you can define a policy on how modules and scripts are checked and possibly blocked:

* **AllSigned**: Requires that all scripts and configuration files are signed by a trusted publisher, including scripts written on the local computer
* **Bypass**: Nothing is blocked and there are no warnings or prompts
* **Default**: Sets the default execution policy. Restricted for Windows clients or RemoteSigned for Windows servers
* **RemoteSigned**: Requires that all scripts and configuration files downloaded from the Internet are signed by a trusted publisher. The default execution policy for Windows server computers
* **Restricted**: Doesn't load configuration files or run scripts. The default execution policy Windows client computers
* **Undefined**: No execution policy is set for the scope. Removes an assigned execution policy from a scope that is not set by a Group Policy. If the execution policy in all scopes is Undefined, the effective execution policy is Restricted
* **Unrestricted**: Loads all configuration files and runs all scripts. If you run an unsigned script that was downloaded from the Internet, you are prompted for permission before it runs

In case your internal security policy defines that PowerShell scripts and modules require being **RemoteSigned**, you can do this for yourself as Icinga is not shipping signed modules. To do so, please have a look on the [Microsoft Docs About Signing](https://docs.microsoft.com/en-us/powershell/module/microsoft.powershell.core/about/about_signing).

To modify the `Execution Policies`, you have to run the PowerShell as Administrator and provide the `Scope` as well as the `Execution Policy`:

```powershell
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope LocalMachine
```

Once applied, you can try to use `Import-Module` again for the affected PowerShell module and checking your Icinga again if checks are now properly executed.
